/***************************************************************************
 * launcher
 * Copyright (C) 2013 Blizzard Entertainment
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***************************************************************************/

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef _WIN32_WINNT
#define _WIN32_WINNT _WIN32_WINNT_WINXP
#endif
#include <Windows.h>
#include <comdef.h>


struct windows_error
{
    windows_error(int errorCode) : errorCode(errorCode) { }
    int errorCode;
};

#define REQUIRE_TRUE(expr) if (!(expr)) throw windows_error(::GetLastError())
#define REQUIRE_ZERO(expr) if ((expr) != 0) throw windows_error(::GetLastError())
#define REQUIRE_NONZERO(expr) if ((expr) == 0) throw windows_error(::GetLastError())
#define REQUIRE_NONNULL(expr) if ((expr) == nullptr) throw windows_error(::GetLastError())
#define REQUIRE_NEQ(value, expr) if ((expr) == (value)) throw windows_error(::GetLastError())
#define REQUIRE_SUCCESS(expr) if (FAILED(hr = (expr))) _com_raise_error(hr)
